/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis;

import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.listener.axis.SOAPMessageUtils;
import filenet.ws.listener.axis.rm.WSRMCallbackData;
import filenet.ws.listener.axis.rm.WSRMMsgProvider;
import filenet.ws.listener.axis.rm.WSRMSequenceInfo;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSLogger;
import filenet.ws.utils.WSOperationInfoHelper;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.w3c.dom.Element;

public class WSProcessor {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis");
    protected static Logger requestLogger = Logger.getLogger("filenet.ws.listener.http.request");
    protected static final String m_className = "WSProcessor";
    private static String EOL = System.getProperty("line.separator", "\n");
    protected static int SYNC_TIMEOUT = 300000;
    protected static boolean SYNC_TIMEOUT_SET = false;
    protected static String HOSTNAME = "localhost";
    private static final String BWRAPPER = "<XXXXX>";
    private static final String EWRAPPER = "</XXXXX>";
    private static Hashtable BlockContexts;
    private boolean wrapped = false;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 17:35:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.40  $";
    }

    private static void getSyncTimeOut(MessageContext msgContext) {
        if (!SYNC_TIMEOUT_SET) {
            try {
                String s;
                WSListenerProperties props = (WSListenerProperties)msgContext.getProperty("MC.P8BPM.LISTENERPROPERTIES");
                if (props != null && (s = props.getProperty("synchronous.timeout")) != null) {
                    int val = Integer.parseInt(s);
                    SYNC_TIMEOUT = val * 1000;
                    SYNC_TIMEOUT_SET = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static int getMessageSyncTimeout(MessageContext msgContext) {
        WSProcessor.getSyncTimeOut(msgContext);
        if (WSRMUtils.hasRMHeaders(msgContext)) {
            return (int)WSRMUtils.getRMTimeout();
        }
        return SYNC_TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkSynchronousSOAPAction(P8BPMSoapActionURI soapActionURI, MessageContext msgContext) throws Exception {
        String ss = soapActionURI.toStringEx();
        String m_method = "checkSynchronousSOAPAction:" + ss;
        String rmSyncReplyWobNum = null;
        if (soapActionURI.isRM()) {
            rmSyncReplyWobNum = soapActionURI.getRMWobNum();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "RM sync reply wobnum = " + rmSyncReplyWobNum);
            }
            P8BPMSoapActionURI soapActionURINoRM = new P8BPMSoapActionURI(ss);
            soapActionURINoRM.setRM(null);
            ss = soapActionURINoRM.toStringEx();
        }
        boolean res = false;
        try {
            logger.entering(m_className, m_method);
            if (!soapActionURI.isSync()) {
                boolean bl = res;
                return bl;
            }
            if (!soapActionURI.getSyncServerName().equals(HOSTNAME)) {
                throw new VWException("filenet.ws.listener.axis.WSProcessor.syncTimeout", "Wrong server name.");
            }
            long now = new Date().getTime();
            WSProcessor.getSyncTimeOut(msgContext);
            if (now - soapActionURI.getSyncTimestamp() > (long)WSProcessor.getMessageSyncTimeout(msgContext)) {
                WSProcessor.throwAxisFaultForSyncOpTimedOut(ss, soapActionURI.getWSDLVersion());
            }
            if (BlockContexts.containsKey(ss)) {
                res = true;
                MessageContext prevMsgContext = null;
                Hashtable hashtable = BlockContexts;
                synchronized (hashtable) {
                    prevMsgContext = (MessageContext)BlockContexts.remove(ss);
                }
                if (soapActionURI.isRM() && rmSyncReplyWobNum != null) {
                    WSRMCallbackData rmCallbackData = (WSRMCallbackData)((Object)prevMsgContext.getProperty("MC.P8BPM.RM.CALLBACK.DATA"));
                    WSRMSequenceInfo seqInfo = null;
                    if (rmCallbackData != null) {
                        String seqId = rmCallbackData.getSequenceId();
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "Setting sync reply wobnum, seqId = " + seqId + ", wobNum = " + rmSyncReplyWobNum);
                        }
                        if ((seqInfo = WSRMSequenceInfo.getSequenceInfoBySeqId(seqId)) != null) {
                            seqInfo.setWobNum(rmSyncReplyWobNum);
                        }
                    }
                }
                prevMsgContext.setRequestMessage(WSProcessor.cloneMessage(msgContext.getRequestMessage()));
                prevMsgContext.setProperty("MC.P8BPM.ISSYNC", (Object)Boolean.FALSE);
                hashtable = prevMsgContext;
                synchronized (hashtable) {
                    if (requestLogger.isFinest()) {
                        requestLogger.finest(m_className, m_method, "RELEASED...");
                    }
                    prevMsgContext.notify();
                }
                boolean bl = res;
                return bl;
            }
            if (requestLogger.isFinest()) {
                requestLogger.finest(m_className, m_method, "Can't find the previously synchonous object!!");
            }
            WSProcessor.throwAxisFaultForSyncOrphanedObject(ss, soapActionURI.getWSDLVersion());
            boolean bl = res;
            return bl;
        }
        finally {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "res=" + new Boolean(res).toString());
            }
            logger.exiting(m_className, m_method);
        }
    }

    private static Message cloneMessage(Message msg) {
        return msg;
    }

    private String getMsg(String s) {
        String ret = !this.wrapped ? s : BWRAPPER + s + EWRAPPER;
        try {
            byte[] bUTF8 = ret.getBytes("UTF-8");
            return new String(bUTF8, "UTF-8");
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getMsg", t);
            return ret;
        }
    }

    public Element[] process(Element[] body) throws Throwable {
        String m_method = "process";
        logger.entering(m_className, m_method);
        WSLogger m_wsLogger = null;
        try {
            MessageContext msgContext;
            if (logger.isFinest() && body != null && body.length > 0 && body[0] != null) {
                logger.finest(m_className, m_method, WSTemplateBase.elementToString(body[0]));
            }
            if ((msgContext = MessageContext.getCurrentContext()) == null) {
                msgContext = WSRMMsgProvider.getMessageContext(body);
            }
            if (msgContext == null) {
                throw new VWException("fileent.ws.listener.axis.WSProcessor.process.invalidMsgContext", "Message Context is invalid.");
            }
            m_wsLogger = (WSLogger)msgContext.getProperty("MC.P8BPM.WSLOGGER");
            if (msgContext.getPastPivot()) {
                if (m_wsLogger != null) {
                    m_wsLogger.append("Past Pivot Set.. returning").eoln();
                }
                Element[] elementArray = null;
                return elementArray;
            }
            WSListenerProperties props = (WSListenerProperties)msgContext.getProperty("MC.P8BPM.LISTENERPROPERTIES");
            if (props != null) {
                this.wrapped = new Boolean(props.getProperty("filenet.ws.wrapped.message", "false"));
            }
            P8BPMSoapActionURI soapActionURI = (P8BPMSoapActionURI)msgContext.getProperty("MC.P8BPM.SOAPACTIONURI");
            boolean isReplying = soapActionURI.isReply();
            String myEndPointReference = this.getMyEndPointReference(props.getProperty("listener.base.url"), (String)msgContext.getProperty("MC.P8BPM.CURRENTPATH"), !isReplying, (String)msgContext.getProperty("MC.P8BPM.REPLYHEADER"));
            if (isReplying) {
                this.handleReceiveForReply(msgContext, soapActionURI, myEndPointReference, m_wsLogger);
                if (m_wsLogger != null) {
                    m_wsLogger.append("OK").eoln();
                }
                Element[] elementArray = null;
                return elementArray;
            }
            Boolean blocked = (Boolean)msgContext.getProperty("MC.P8BPM.ISSYNC");
            if (blocked == null || !blocked.booleanValue()) {
                this.handleReceive(msgContext, soapActionURI, myEndPointReference, m_wsLogger);
                if (m_wsLogger != null) {
                    m_wsLogger.append("OK").eoln();
                }
                Element[] elementArray = null;
                return elementArray;
            }
            this.blockForSynchronousReceive(msgContext, soapActionURI, myEndPointReference, m_wsLogger);
            Element[] elementArray = null;
            return elementArray;
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            if (m_wsLogger != null) {
                m_wsLogger.append("Exception=" + t.getMessage()).eoln();
            }
            throw t;
        }
        finally {
            logger.exiting(m_className, m_method);
            if (m_wsLogger != null) {
                m_wsLogger.println("WSProcessor Exits");
            }
        }
    }

    private String getMyEndPointReference(String baseURL, String path, boolean appendReplyHeader, String replyHeader) {
        String endQuote = "\">\n";
        String myEndPoint = baseURL + path;
        StringBuffer buf = new StringBuffer("<EndPointReference xmlns=\"");
        buf.append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\">\n");
        buf.append("<Address>").append(myEndPoint).append("</Address>");
        if (appendReplyHeader) {
            buf.append("<ReferenceProperties>").append(replyHeader).append("</ReferenceProperties>");
        }
        buf.append("</EndPointReference>");
        String s = buf.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "getMyEndPointReference", s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CreateLiveWorkObject(VWSession vwSession, String[] fieldNames, Object[] fieldValues, String workflowId, WSLogger m_wsLogger) throws VWException {
        block24: {
            String m_method = "CreateLiveWorkObject";
            logger.entering(m_className, m_method);
            if (m_wsLogger != null) {
                m_wsLogger.append("CreateLiveWorkObject Parameter List:").eoln();
                int nFields = fieldNames == null ? 0 : fieldNames.length;
                for (int i = 0; i < nFields; ++i) {
                    m_wsLogger.append("[").append(Integer.toString(i)).append("]=").append(fieldNames[i]).eoln();
                }
                int nFieldVals = fieldValues == null ? 0 : fieldValues.length;
                for (int i = 0; i < nFieldVals; ++i) {
                    m_wsLogger.append("[").append(Integer.toString(nFields + i)).append("]=").append(Logger.asString(fieldValues[i])).eoln();
                }
                m_wsLogger.print(null);
            }
            try {
                if (vwSession != null) {
                    if (logger.isFinest() && fieldNames[4] != null) {
                        m_method = m_method + ": " + fieldNames[4];
                        logger.finest(m_className, m_method, "workclass name = " + fieldNames[4]);
                    }
                    if (logger.isFinest() && fieldNames[5] != null) {
                        logger.finest(m_className, m_method, "reply wobnum = " + fieldNames[5]);
                    }
                    int retryCount = 0;
                    int retries = 10;
                    StringBuffer buf = null;
                    do {
                        if (retryCount != 0) {
                            try {
                                long interval = (long)Math.pow(3.0, retryCount) * 1000L;
                                if (interval > 60000L) {
                                    interval = 60000L;
                                }
                                Thread.sleep(interval);
                            }
                            catch (InterruptedException iex) {
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                        }
                        buf = new StringBuffer("reply wobnum = " + fieldNames[5]);
                        buf.append(EOL);
                        buf.append(fieldNames[5]).append(", retry ").append(retryCount).append(EOL);
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, buf.toString());
                        }
                        try {
                            VWCreateLiveWOResult[] results = vwSession.createLiveWorkObject(fieldNames, fieldValues, workflowId, 92626);
                            buf = new StringBuffer();
                            if (results != null && results.length > 0) {
                                String resultString = results[0].toString();
                                long errnum = results[0].getErrorTuple();
                                buf.append(", errnum = ").append(errnum).append(", result =").append(resultString).append("\n");
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, buf.toString());
                                }
                                if (resultString.indexOf("d56d0027") != -1) continue;
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, "Failed!");
                                }
                            } else {
                                buf.append(" - No results returned");
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, buf.toString());
                                }
                            }
                            break block24;
                        }
                        catch (VWException ex) {
                            String msg = ex.getLocalizedMessage();
                            if (msg.indexOf("d56d0027") != -1 && retryCount < retries - 1) continue;
                            logger.throwing(m_className, m_method, ex);
                            throw ex;
                        }
                        catch (Exception e) {
                            VWException vwex = new VWException("filenet.ws.listener.axis.WSProcessor.failedCreateLiveWorkObject", "Faile CreateLiveWorkObject");
                            vwex.setCause(e);
                            throw vwex;
                        }
                    } while (++retryCount < retries);
                    break block24;
                }
                throw new VWException("filenet.ws.listener.axis.WSProcessor.noVWSession", "No VW Session available.");
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }

    private void handleReceiveForReply(MessageContext msgContext, P8BPMSoapActionURI soapActionURI, String myEndPointReference, WSLogger m_wsLogger) throws Throwable {
        String m_method = "handleReceiveForReply:" + soapActionURI.toStringEx();
        logger.entering(m_className, m_method);
        try {
            String[] fieldNames = new String[]{"P8-3.0-1", "invoke-reply", soapActionURI.getPortType(), soapActionURI.getOperation(), soapActionURI.getWorkClassName(), soapActionURI.getReplyWobNum(), soapActionURI.getOnlineId(), soapActionURI.getMapId()};
            boolean bRMMessage = WSRMUtils.hasRMHeaders(msgContext);
            String msg = this.getMsg((String)msgContext.getProperty("MC.P8BPM.INMSG"));
            String fault = (String)msgContext.getProperty("MC.P8BPM.FAULT");
            Vector<String> v = new Vector<String>();
            v.add("0");
            v.add(myEndPointReference == null ? "" : myEndPointReference);
            v.add(msg == null ? "" : msg);
            v.add(soapActionURI.getWorkClassRevision());
            v.add(fault == null ? "" : fault);
            v.add(bRMMessage ? "1" : "0");
            WSOperationInfoHelper opInfoHelper = (WSOperationInfoHelper)msgContext.getProperty("MC.P8BPM.OPINFO.HELPER");
            if (opInfoHelper != null) {
                String[] corrSets = opInfoHelper.getWSListenerParamsForCreateLiveWorkObject();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "CorrSet as Strings:" + Logger.asString(corrSets));
                }
                int nCorrSets = corrSets == null ? 0 : corrSets.length;
                for (int i = 0; i < nCorrSets; ++i) {
                    v.add(corrSets[i]);
                }
            }
            Object[] fieldValues = v.toArray(new Object[0]);
            String workflowId = "~1" + soapActionURI.getVWVersion().toString();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "workflowId = " + workflowId);
            }
            this.CreateLiveWorkObject((VWSession)msgContext.getProperty("MC.P8BPM.VWSESSION"), fieldNames, fieldValues, workflowId, m_wsLogger);
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            throw t;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private void handleReceive(MessageContext msgContext, P8BPMSoapActionURI soapActionURI, String myEndPointReference, WSLogger m_wsLogger) throws Throwable {
        String m_method = "handleReceive:" + soapActionURI.toStringEx();
        logger.entering(m_className, m_method);
        try {
            boolean bRMMessage = WSRMUtils.hasRMHeaders(msgContext);
            if (bRMMessage) {
                String seqId;
                WSRMSequenceInfo seqInfo = null;
                WSRMCallbackData rmCallbackData = (WSRMCallbackData)((Object)msgContext.getProperty("MC.P8BPM.RM.CALLBACK.DATA"));
                if (rmCallbackData != null && (seqInfo = WSRMSequenceInfo.getSequenceInfoBySeqId(seqId = rmCallbackData.getSequenceId())) != null && seqInfo.setServicePerformed()) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "This request has already been done. Skip it!");
                    }
                    return;
                }
            }
            String[] fieldNames = new String[]{"P8-3.0-1", "receive", soapActionURI.getPortType(), soapActionURI.getOperation(), soapActionURI.getWorkClassName(), "", soapActionURI.getOnlineId(), soapActionURI.getMapId()};
            String msg = this.getMsg((String)msgContext.getProperty("MC.P8BPM.INMSG"));
            Vector<String> v = new Vector<String>();
            v.add("0");
            v.add(myEndPointReference);
            v.add(msg == null ? "" : msg);
            v.add(soapActionURI.getWorkClassRevision());
            v.add("");
            v.add(bRMMessage ? "1" : "0");
            WSOperationInfoHelper opInfoHelper = (WSOperationInfoHelper)msgContext.getProperty("MC.P8BPM.OPINFO.HELPER");
            if (opInfoHelper != null) {
                String[] corrSets = opInfoHelper.getWSListenerParamsForCreateLiveWorkObject();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "CorrSet as Strings:" + Logger.asString(corrSets));
                }
                int nCorrSets = corrSets == null ? 0 : corrSets.length;
                for (int i = 0; i < nCorrSets; ++i) {
                    v.add(corrSets[i]);
                }
            }
            Object[] fieldValues = v.toArray(new Object[0]);
            String workflowId = "~1" + soapActionURI.getVWVersion().toString();
            this.CreateLiveWorkObject((VWSession)msgContext.getProperty("MC.P8BPM.VWSESSION"), fieldNames, fieldValues, workflowId, m_wsLogger);
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            throw t;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockForSynchronousReceive(MessageContext msgContext, P8BPMSoapActionURI soapActionURI, String myEndPointReference, WSLogger m_wsLogger) throws Throwable {
        String newSOAPActionURI = soapActionURI.toStringEx();
        String m_method = "blockForSynchronousReceive:" + newSOAPActionURI;
        try {
            logger.entering(m_className, m_method);
            if (m_wsLogger != null) {
                m_wsLogger.append("WSProcessor Synchronous Op Blocking....").eoln();
            }
            Hashtable hashtable = BlockContexts;
            synchronized (hashtable) {
                BlockContexts.put(newSOAPActionURI, msgContext);
            }
            boolean timedOut = false;
            try {
                WSProcessor.getSyncTimeOut(msgContext);
                MessageContext messageContext = msgContext;
                synchronized (messageContext) {
                    this.handleReceive(msgContext, soapActionURI, myEndPointReference, m_wsLogger);
                    if (requestLogger.isFinest()) {
                        requestLogger.finest(m_className, m_method, "... WAITING ...");
                    }
                    msgContext.wait(WSProcessor.getMessageSyncTimeout(msgContext));
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Boolean stillBlocked = (Boolean)msgContext.getProperty("MC.P8BPM.ISSYNC");
            if (stillBlocked == null || !stillBlocked.booleanValue()) {
                Object obj;
                if (requestLogger.isFinest()) {
                    requestLogger.finest(m_className, m_method, "... FREE AT LAST ...");
                }
                if (m_wsLogger != null) {
                    m_wsLogger.append("WSProcessor Synchronous Op Released...").eoln();
                }
                if ((obj = msgContext.getProperty("MC.P8BPM.RM.HAS.RESPONSE")) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Set response message");
                    }
                    Message msg = msgContext.getRequestMessage();
                    msg.setMessageType("response");
                    msgContext.setResponseMessage(msg);
                    m_wsLogger = (WSLogger)msgContext.getProperty("MC.P8BPM.WSLOGGER");
                    if (m_wsLogger != null) {
                        StringBuffer buf = SOAPMessageUtils.exploreMessage((SOAPMessage)msg);
                        m_wsLogger.append("Response SOAP Message=").append(buf).eoln();
                        m_wsLogger.println("PostHandler OK.");
                    }
                } else {
                    msgContext.setProperty("MC.P8BPM.POST.REQUIRED", (Object)Boolean.TRUE);
                }
                return;
            }
            if (requestLogger.isFinest()) {
                requestLogger.finest(m_className, m_method, "... TIMED OUT! ...");
            }
            Hashtable hashtable2 = BlockContexts;
            synchronized (hashtable2) {
                if (BlockContexts.containsKey(newSOAPActionURI)) {
                    BlockContexts.remove(newSOAPActionURI);
                }
            }
            if (m_wsLogger != null) {
                m_wsLogger.println("WSProcessor Synchronous Op TIMED OUT!");
            }
            WSProcessor.throwAxisFaultForSyncOpTimedOut(newSOAPActionURI, soapActionURI.getWSDLVersion());
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    protected static void throwAxisFaultForSyncOpTimedOut(String desc, int WSDLVersion) throws AxisFault {
        String m_method = "throwAxisFaultForSyncOpTimedOut";
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, desc);
        }
        QName fault = WSConstants.getWSConstants((int)WSDLVersion).FAULT_SYNC_OP_TIMED_OUT;
        AxisFault retFault = new AxisFault(fault, desc, null, null);
        retFault.addFaultDetail(fault, desc);
        logger.throwing(m_className, m_method, retFault);
        throw retFault;
    }

    protected static void throwAxisFaultForSyncOrphanedObject(String desc, int WSDLVersion) throws AxisFault {
        String m_method = "throwAxisFaultForSyncOrphanedObject";
        logger.finest(m_className, m_method, desc);
        QName fault = WSConstants.getWSConstants((int)WSDLVersion).FAULT_SYNC_ORPHANED_OBJECT;
        AxisFault retFault = new AxisFault(fault, desc, null, null);
        retFault.addFaultDetail(fault, desc);
        logger.throwing(m_className, m_method, retFault);
        throw retFault;
    }

    static {
        try {
            HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BlockContexts = new Hashtable();
    }
}

